/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.api.VWScenarioArrivalDefinition;
import filenet.sim.api.VWScenarioArrivalPattern;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMArrivalsDataFieldsTableModel;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMArrivalsTableModel;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMArrivalsTypeTableCellRenderer;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMCustomArrivalPanel;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMProductionArrivalPanel;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.tables.VWExpressionCellEditor;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.table.VWFieldNameRenderer;
import filenet.vw.toolkit.utils.table.VWFieldTypeRenderer;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWSIMArrivalsTab
extends JPanel
implements ActionListener,
ListSelectionListener,
TableModelListener,
IVWToolbarBorderActionListener {
    protected VWToolbarBorder m_arrivalsBorder = null;
    protected VWTable m_arrivalsTable = null;
    protected VWSIMArrivalsTableModel m_arrivalsTableModel = null;
    protected VWTable m_initialDataFieldsTable = null;
    protected VWSIMArrivalsDataFieldsTableModel m_initialDataFieldsTableModel = null;
    protected JRadioButton m_productionArrivalRadioButton = null;
    protected JRadioButton m_customArrivalRadioButton = null;
    protected CardLayout m_cardLayout = null;
    protected CardLayout m_fieldsTableCardLayout = null;
    protected JPanel m_propertiesPanel = null;
    protected JPanel m_fieldsTablePanel = null;
    protected VWSIMProductionArrivalPanel m_productionPanel = null;
    protected VWSIMCustomArrivalPanel m_customPanel = null;
    protected VWScenarioWorkflowDefinition m_scenarioWflDef = null;
    protected VWSIMPropertyData m_propertyData = null;
    protected boolean m_bReplace = true;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.createControls();
        this.m_cardLayout.show(this.m_propertiesPanel, VWSIMResource.s_customArrival);
    }

    public void changeWorkflow(String workflowName) {
        try {
            if (workflowName != null) {
                this.m_scenarioWflDef = this.m_propertyData.getScenarioDefinition().getWorkflow(workflowName);
                this.setEnabled(false);
                Object[] arrivalDefs = this.m_scenarioWflDef.getArrivals(3);
                this.m_arrivalsTableModel.reinitialize(arrivalDefs, this.m_scenarioWflDef);
                for (int i = 0; i < arrivalDefs.length; ++i) {
                    if (!(arrivalDefs[i] instanceof VWScenarioArrivalDefinition)) continue;
                    this.resetScenarioDataFields((VWScenarioArrivalDefinition)arrivalDefs[i]);
                }
            } else {
                this.m_scenarioWflDef = null;
                this.setEnabled(false);
                this.m_arrivalsTableModel.reinitialize(null, null);
                this.m_initialDataFieldsTableModel.reinitialize(null, null);
                this.m_customPanel.setArrivalDefinition(this.m_propertyData, null);
                this.m_productionPanel.setArrivalPattern(this.m_propertyData, null);
            }
            this.m_arrivalsTable.clearSelection();
            if (this.m_arrivalsTableModel.getRowCount() > 0) {
                this.m_arrivalsTable.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_arrivalsTable != null) {
            int[] columnSizes = new int[2];
            int width = this.m_arrivalsTable.getViewPortWidth() - 20;
            columnSizes[0] = 20;
            columnSizes[1] = width;
            this.m_arrivalsTable.fitColumnsInTable(columnSizes);
        }
    }

    public void setEnabled(boolean bEnable) {
        this.m_customArrivalRadioButton.setEnabled(bEnable);
        this.m_productionArrivalRadioButton.setEnabled(bEnable);
        this.m_customPanel.enablePropertyPanel(bEnable);
        this.m_productionPanel.enablePropertyPanel(bEnable);
        int nFlags = 2;
        if (this.m_scenarioWflDef != null) {
            this.m_arrivalsTable.setEnabled(true);
            this.m_initialDataFieldsTable.setEnabled(true);
            nFlags = 1;
        } else {
            this.m_arrivalsTable.setEnabled(false);
            this.m_initialDataFieldsTable.setEnabled(false);
        }
        this.m_arrivalsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrivalsBorder.getClientPanel(), nFlags, 16));
        super.setEnabled(bEnable);
    }

    public void releaseReferences() {
        this.m_arrivalsBorder = null;
        this.m_arrivalsTable = null;
        this.m_arrivalsTableModel = null;
        this.m_productionArrivalRadioButton = null;
        this.m_customArrivalRadioButton = null;
        this.m_cardLayout = null;
        this.m_propertiesPanel = null;
        this.m_productionPanel = null;
        this.m_customPanel = null;
        this.m_scenarioWflDef = null;
        this.m_propertyData = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_productionArrivalRadioButton) {
            this.performProductionArrivalRadioButton();
        } else if (src == this.m_customArrivalRadioButton) {
            this.performCustomArrivalRadioButton();
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.updateControlStates();
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_arrivalsTable.getSelectedRow()) {
                    this.m_arrivalsTable.clearSelection();
                }
                if (nRow >= 0 && this.m_arrivalsTableModel != null && this.m_arrivalsTableModel.getRowCount() > 0) {
                    VWScenarioArrivalDefinition arrival;
                    this.m_arrivalsTable.setRowSelectionInterval(nRow, nRow);
                    if (event.getType() != 1 || this.m_arrivalsTableModel == null || (arrival = (VWScenarioArrivalDefinition)this.m_arrivalsTableModel.getItemAt(nRow)) == null) break;
                    this.resetScenarioDataFields(arrival);
                    if (this.m_initialDataFieldsTableModel == null) break;
                    this.m_initialDataFieldsTableModel.reinitialize(arrival, this.m_scenarioWflDef);
                    break;
                }
                this.updateControlStates();
                break;
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            int nSelectedRow = this.m_arrivalsTable.getSelectedRow();
            switch (event.getID()) {
                case 16: {
                    this.m_arrivalsTableModel.addItem();
                    break;
                }
                case 64: {
                    this.m_arrivalsTableModel.copyItem(nSelectedRow);
                    break;
                }
                case 0x10000000: {
                    this.m_arrivalsTableModel.deleteItem(nSelectedRow);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void createControls() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.anchor = 23;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        JPanel childPanel = this.getTableControlPanel();
        if (childPanel != null) {
            this.add((Component)childPanel, gbCons);
        }
        ++gbCons.gridy;
        gbCons.fill = 2;
        gbCons.weighty = 0.0;
        childPanel = this.getTypeControlPanel();
        if (childPanel != null) {
            this.add((Component)childPanel, gbCons);
        }
        ++gbCons.gridy;
        gbCons.insets = new Insets(0, 0, 0, 5);
        childPanel = this.getArrivalPropertiesControlPanel();
        if (childPanel != null) {
            this.add((Component)childPanel, gbCons);
        }
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        childPanel = this.getInitialDataFieldsTableControlPanel();
        if (childPanel != null) {
            this.add((Component)childPanel, gbCons);
        }
    }

    protected JPanel getTableControlPanel() {
        try {
            this.m_arrivalsBorder = new VWToolbarBorder(VWSIMResource.s_arrivals, 0x10000050);
            this.m_arrivalsBorder.addToolbarBorderActionNotifier(this);
            this.m_arrivalsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrivalsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            JPanel clientPanel = this.m_arrivalsBorder.getClientPanel();
            clientPanel.setLayout(new GridLayout());
            this.m_arrivalsTableModel = new VWSIMArrivalsTableModel(this.m_propertyData);
            this.m_arrivalsTableModel.addTableModelListener(this);
            this.m_arrivalsTable = new VWTable(this.m_arrivalsTableModel);
            TableColumn tcElement = this.m_arrivalsTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                tcElement.setCellRenderer(new VWSIMArrivalsTypeTableCellRenderer());
            }
            this.m_arrivalsTable.setEnabled(false);
            this.m_arrivalsTable.setRowSelectionAllowed(true);
            this.m_arrivalsTable.getSelectionModel().addListSelectionListener(this);
            this.m_arrivalsTable.getSelectionModel().setSelectionMode(0);
            this.m_arrivalsTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_arrivalsTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            clientPanel.add(new JScrollPane(this.m_arrivalsTable));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_arrivalsBorder;
    }

    protected JPanel getTypeControlPanel() {
        try {
            VWToolbarBorder arrivalTypeBorder = new VWToolbarBorder(VWSIMResource.s_arrivalType);
            JPanel clientPanel = arrivalTypeBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            this.m_productionArrivalRadioButton = new JRadioButton(VWSIMResource.s_productionData);
            buttonGroup.add(this.m_productionArrivalRadioButton);
            this.m_productionArrivalRadioButton.setEnabled(false);
            this.m_productionArrivalRadioButton.setSelected(false);
            this.m_productionArrivalRadioButton.addActionListener(this);
            clientPanel.add((Component)this.m_productionArrivalRadioButton, gbCons);
            ++gbCons.gridx;
            this.m_customArrivalRadioButton = new JRadioButton(VWSIMResource.s_customArrival);
            buttonGroup.add(this.m_customArrivalRadioButton);
            this.m_customArrivalRadioButton.setEnabled(false);
            this.m_customArrivalRadioButton.setSelected(true);
            this.m_customArrivalRadioButton.addActionListener(this);
            clientPanel.add((Component)this.m_customArrivalRadioButton, gbCons);
            return arrivalTypeBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel getArrivalPropertiesControlPanel() {
        this.m_customPanel = new VWSIMCustomArrivalPanel(this.m_propertyData);
        this.m_customPanel.init();
        this.m_productionPanel = new VWSIMProductionArrivalPanel(this.m_propertyData);
        this.m_productionPanel.init();
        this.m_cardLayout = new CardLayout();
        this.m_propertiesPanel = new JPanel(this.m_cardLayout);
        this.m_propertiesPanel.add((Component)this.m_productionPanel, VWSIMResource.s_productionData);
        this.m_propertiesPanel.add((Component)this.m_customPanel, VWSIMResource.s_customArrival);
        return this.m_propertiesPanel;
    }

    protected JPanel getInitialDataFieldsTableControlPanel() {
        VWToolbarBorder initialDataFieldsBorder = null;
        VWFieldTypeRenderer m_fieldTypeRenderer = new VWFieldTypeRenderer();
        VWFieldNameRenderer m_fieldNameRenderer = new VWFieldNameRenderer();
        VWFieldsCellRenderer m_fieldsCellRenderer = new VWFieldsCellRenderer();
        try {
            initialDataFieldsBorder = new VWToolbarBorder(VWSIMResource.s_initialDataFieldValues);
            JPanel clientPanel = initialDataFieldsBorder.getClientPanel();
            clientPanel.setLayout(new GridLayout());
            this.m_initialDataFieldsTableModel = new VWSIMArrivalsDataFieldsTableModel(this.m_propertyData);
            this.m_initialDataFieldsTableModel.addTableModelListener(this);
            this.m_initialDataFieldsTable = new VWTable(this.m_initialDataFieldsTableModel);
            this.m_initialDataFieldsTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_initialDataFieldsTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            TableColumn columnName = this.m_initialDataFieldsTable.getColumnModel().getColumn(0);
            TableColumn columnType = this.m_initialDataFieldsTable.getColumnModel().getColumn(1);
            TableColumn columnValue = this.m_initialDataFieldsTable.getColumnModel().getColumn(2);
            columnType.setMinWidth(20);
            int width = m_fieldTypeRenderer.getMaxWidth(true);
            if (width != 0) {
                columnType.setMaxWidth(width += 4);
                columnType.setPreferredWidth(width);
            }
            columnName.setMinWidth(50);
            columnValue.setMinWidth(50);
            columnType.setCellRenderer(m_fieldTypeRenderer);
            columnName.setCellRenderer(m_fieldNameRenderer);
            columnValue.setCellRenderer(m_fieldsCellRenderer);
            columnValue.setCellEditor(new VWExpressionCellEditor((IVWPropertyData)this.m_propertyData, true));
            columnValue.setCellRenderer(new VWToolTipTableCellRenderer());
            this.m_initialDataFieldsTable.setEnabled(false);
            this.m_initialDataFieldsTable.setRowSelectionAllowed(true);
            this.m_initialDataFieldsTable.getSelectionModel().setSelectionMode(0);
            clientPanel.add(new JScrollPane(this.m_initialDataFieldsTable));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_fieldsTableCardLayout = new CardLayout();
        this.m_fieldsTablePanel = new JPanel(this.m_fieldsTableCardLayout);
        this.m_fieldsTablePanel.add((Component)new JPanel(), VWSIMResource.s_productionData);
        this.m_fieldsTablePanel.add((Component)initialDataFieldsBorder, VWSIMResource.s_customArrival);
        return this.m_fieldsTablePanel;
    }

    private void performProductionArrivalRadioButton() {
        try {
            int nRow = this.m_arrivalsTable.getSelectedRow();
            this.m_arrivalsTableModel.changeItemType(1, nRow);
            VWScenarioArrivalPattern arrivalPattern = (VWScenarioArrivalPattern)this.m_arrivalsTableModel.getItemAt(nRow);
            arrivalPattern.setStartTime(new VWScenarioTimeDuration("0", 3));
            this.m_productionPanel.setArrivalPattern(this.m_propertyData, arrivalPattern);
            this.m_cardLayout.show(this.m_propertiesPanel, VWSIMResource.s_productionData);
            this.m_fieldsTableCardLayout.show(this.m_fieldsTablePanel, VWSIMResource.s_productionData);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performCustomArrivalRadioButton() {
        try {
            int nRow = this.m_arrivalsTable.getSelectedRow();
            this.m_arrivalsTableModel.changeItemType(0, nRow);
            VWScenarioArrivalDefinition arrivalDef = (VWScenarioArrivalDefinition)this.m_arrivalsTableModel.getItemAt(nRow);
            arrivalDef.setStartTime(new VWScenarioTimeDuration("0", 3));
            this.m_customPanel.setArrivalDefinition(this.m_propertyData, arrivalDef);
            this.m_cardLayout.show(this.m_propertiesPanel, VWSIMResource.s_customArrival);
            this.resetScenarioDataFields(arrivalDef);
            this.m_initialDataFieldsTableModel.setArrivalDefinition(this.m_propertyData, this.m_scenarioWflDef, arrivalDef);
            this.m_fieldsTableCardLayout.show(this.m_fieldsTablePanel, VWSIMResource.s_customArrival);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateControlStates() {
        try {
            this.m_arrivalsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrivalsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nSelectedRow = this.m_arrivalsTable.getSelectedRow();
            Object arrival = null;
            if (this.m_arrivalsTableModel != null) {
                if (nSelectedRow != -1) {
                    this.m_arrivalsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrivalsBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                }
                arrival = this.m_arrivalsTableModel.getItemAt(nSelectedRow);
            }
            if (arrival != null) {
                this.setEnabled(true);
                if (arrival instanceof VWScenarioArrivalDefinition) {
                    this.m_customArrivalRadioButton.removeActionListener(this);
                    this.m_customArrivalRadioButton.setSelected(true);
                    this.m_customArrivalRadioButton.addActionListener(this);
                    this.m_cardLayout.show(this.m_propertiesPanel, VWSIMResource.s_customArrival);
                    this.m_customPanel.setArrivalDefinition(this.m_propertyData, (VWScenarioArrivalDefinition)arrival);
                    this.m_initialDataFieldsTableModel.setArrivalDefinition(this.m_propertyData, this.m_scenarioWflDef, (VWScenarioArrivalDefinition)arrival);
                    this.m_fieldsTableCardLayout.show(this.m_fieldsTablePanel, VWSIMResource.s_customArrival);
                } else if (arrival instanceof VWScenarioArrivalPattern) {
                    this.m_productionArrivalRadioButton.removeActionListener(this);
                    this.m_productionArrivalRadioButton.setSelected(true);
                    this.m_productionArrivalRadioButton.addActionListener(this);
                    this.m_cardLayout.show(this.m_propertiesPanel, VWSIMResource.s_productionData);
                    this.m_productionPanel.setArrivalPattern(this.m_propertyData, (VWScenarioArrivalPattern)arrival);
                    this.m_fieldsTableCardLayout.show(this.m_fieldsTablePanel, VWSIMResource.s_productionData);
                }
            } else {
                this.setEnabled(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void resetScenarioDataFields(VWScenarioArrivalDefinition arrivalDef) {
        VWWorkflowDefinition wfDef = null;
        String[][] fields = null;
        if (this.m_scenarioWflDef != null) {
            wfDef = this.m_scenarioWflDef.getWorkflowDefinition();
        }
        try {
            VWFieldDefinition[] fieldDefs;
            if (arrivalDef != null && (fields = arrivalDef.getFieldAssignments()) == null && (fieldDefs = wfDef.getFields()) != null) {
                ArrayList<String[]> fieldsList = new ArrayList<String[]>();
                for (int i = 0; i < fieldDefs.length; ++i) {
                    int type;
                    if (fieldDefs[i].isArray() || ((type = fieldDefs[i].getFieldType()) & 0x1F) == 0) continue;
                    String name = fieldDefs[i].getName();
                    String value = fieldDefs[i].getStringValue();
                    String[] field = new String[]{null, null};
                    field[0] = name;
                    field[1] = value;
                    fieldsList.add(field);
                }
                fields = (String[][])fieldsList.toArray((T[])new String[0][0]);
                arrivalDef.setFieldAssignments(fields);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

